/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QT3DANIMATION_QABSTRACTCLIPANIMATOR_P_H
#define QT3DANIMATION_QABSTRACTCLIPANIMATOR_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DCore/private/qcomponent_p.h>

QT_BEGIN_NAMESPACE

namespace Qt3DAnimation {

class QChannelMapper;
class QClock;

class QAbstractClipAnimatorPrivate : public Qt3DCore::QComponentPrivate
{
public:
    QAbstractClipAnimatorPrivate();

    virtual bool canPlay() const;

    Q_DECLARE_PUBLIC(QAbstractClipAnimator)

    Qt3DAnimation::QChannelMapper *m_mapper;
    Qt3DAnimation::QClock *m_clock;
    bool m_running;
    int m_loops;
    float m_normalizedTime;
};

struct QAbstractClipAnimatorData
{
    Qt3DCore::QNodeId mapperId;
    Qt3DCore::QNodeId clockId;
    bool running;
    float normalizedTime;
    int loops;
};

} // namespace Qt3DAnimation


QT_END_NAMESPACE

#endif // QT3DANIMATION_QABSTRACTCLIPANIMATOR_P_H
